/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.compat.jei.crucible.JEICrucibleRecipe;
import novamachina.exnihilosequentia.common.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class CrucibleRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private final List<CrucibleRecipe> recipeList = new ArrayList<CrucibleRecipe>();
    @Nonnull
    private final Map<Item, CrucibleRecipe> recipeByItemCache = new HashMap<Item, CrucibleRecipe>();

    @Nonnull
    public List<JEICrucibleRecipe> getRecipeList() {
        return this.recipeList.stream().flatMap(crucibleRecipe -> {
            if (crucibleRecipe.getInputs().size() <= 21) {
                return Stream.of(new JEICrucibleRecipe(crucibleRecipe.getAmount(), crucibleRecipe.getCrucibleType(), crucibleRecipe.getInputs(), crucibleRecipe.getResultFluid()));
            }
            List partitions = Lists.partition(crucibleRecipe.getInputs(), (int)21);
            return partitions.stream().map(partition -> new JEICrucibleRecipe(crucibleRecipe.getAmount(), crucibleRecipe.getCrucibleType(), (List<ItemStack>)partition, crucibleRecipe.getResultFluid()));
        }).collect(Collectors.toList());
    }

    public void setRecipes(@Nonnull List<CrucibleRecipe> recipes) {
        logger.debug("Crucible Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }

    @Nonnull
    public Optional<CrucibleRecipe> findRecipeByItemStack(@Nonnull ItemStack itemStack) {
        return Optional.ofNullable(this.recipeByItemCache.computeIfAbsent(itemStack.m_41720_(), k -> this.recipeList.stream().filter(recipe -> recipe.getInput().test(itemStack)).findFirst().orElse(null)));
    }

    @Nonnull
    public Optional<CrucibleRecipe> findRecipeByItem(@Nonnull Item item) {
        return Optional.ofNullable(this.recipeByItemCache.computeIfAbsent(item, k -> {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            return this.recipeList.stream().filter(recipe -> recipe.getInput().test(itemStack)).findFirst().orElse(null);
        }));
    }

    public boolean isMeltable(@Nonnull ItemLike item, int level) {
        return this.isMeltableByItem(item.m_5456_(), level);
    }

    public boolean isMeltableByItemStack(@Nonnull ItemStack itemStack, int level) {
        Optional<CrucibleRecipe> recipe = this.findRecipeByItemStack(itemStack);
        return recipe.isPresent() && recipe.get().getCrucibleType().getLevel() <= level;
    }

    public boolean isMeltableByItem(@Nonnull Item item, int level) {
        Optional<CrucibleRecipe> recipe = this.findRecipeByItem(item);
        return recipe.isPresent() && recipe.get().getCrucibleType().getLevel() <= level;
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.recipeByItemCache.clear();
    }
}

